/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.command;

import com.google.common.collect.Sets;
import cz.insophy.inplan.command.Command;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.planning.mokos.MokosRunner;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.problems.Problem;
import cz.insophy.inplan.validation.PlanNotValidException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PauseGorsCommand
implements Command {
    private static final long serialVersionUID = 1L;
    private Set<String> gorIds = new HashSet<String>();
    private OffsetStartPoint offsetStartPoint = OffsetStartPoint.RELEASE_DATE;
    private int pauseOffsetAmount = 14;
    private int pauseOffsetCalendarField = 5;
    private boolean changeToPaused = false;

    public void setGorIds(Set<String> gorIds) {
        this.gorIds = gorIds;
    }

    public void setOffsetStartPoint(OffsetStartPoint offsetStartPoint) {
        this.offsetStartPoint = offsetStartPoint;
    }

    public void setPauseOffsetAmount(int pauseOffsetAmount) {
        this.pauseOffsetAmount = pauseOffsetAmount;
    }

    public void setPauseOffsetCalendarField(int pauseOffsetCalendarField) {
        this.pauseOffsetCalendarField = pauseOffsetCalendarField;
    }

    public void setChangeToPaused(boolean changeToPaused) {
        this.changeToPaused = changeToPaused;
    }

    public Set<String> getGorIds() {
        return this.gorIds;
    }

    public OffsetStartPoint getOffsetStartPoint() {
        return this.offsetStartPoint;
    }

    public int getPauseOffsetAmount() {
        return this.pauseOffsetAmount;
    }

    public int getPauseOffsetCalendarField() {
        return this.pauseOffsetCalendarField;
    }

    public boolean isChangeToPaused() {
        return this.changeToPaused;
    }

    public boolean isVirtualGorIncluded(Superplan superplan) {
        for (String gorId : this.gorIds) {
            GeneralizedOrderRequest gor = superplan.getGor(gorId);
            if (gor == null || gor.getState() != GeneralizedOrderRequest.State.VIRTUAL) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.gorIds.size() <= 5) {
            return Localizer.getString("command.pause_gors.desc", this.gorIds.toString());
        }
        return Localizer.getString("command.pause_gors.desc", this.gorIds.size());
    }

    @Override
    public List<Problem> execute(Superplan superplan) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        HashSet<GeneralizedOrderRequest> origSelectedGors = Sets.newHashSet(superplan.getUserSelectedGors());
        Set<GeneralizedOrderRequest> gorsToProcess = this.findGors(superplan, problems);
        this.updateGors(gorsToProcess, problems);
        Set<GeneralizedOrderRequest> transitiveGors = this.findTransitiveGors(superplan, gorsToProcess);
        this.removeGorsFromSuperplan(transitiveGors, problems);
        this.fixRebuilds(superplan);
        this.replanGors(superplan, transitiveGors, problems);
        this.fixRebuilds(superplan);
        this.userSelectGors(superplan, origSelectedGors);
        return problems;
    }

    private Set<GeneralizedOrderRequest> findGors(Superplan superplan, List<Problem> problems) {
        HashSet<GeneralizedOrderRequest> gors = Sets.newHashSet();
        for (String gorId : this.gorIds) {
            GeneralizedOrderRequest gor = superplan.getGor(gorId);
            if (gor != null) {
                gors.add(gor);
                continue;
            }
            problems.add(Problem.createProblem2("03000", gorId));
        }
        return gors;
    }

    private Set<GeneralizedOrderRequest> findTransitiveGors(Superplan superplan, Set<GeneralizedOrderRequest> gors) {
        StoreDependencyGraph sdg = superplan.getSDGraph();
        HashSet<GeneralizedOrderRequest> result = Sets.newHashSet();
        result.addAll(gors);
        for (GeneralizedOrderRequest gor : gors) {
            for (SdgGorNode dependant : sdg.getNode(gor).getTransitiveSuccessors(SdgGorNode.class)) {
                result.add(dependant.getGor());
            }
        }
        return result;
    }

    private void updateGors(Set<GeneralizedOrderRequest> gors, List<Problem> problems) {
        for (GeneralizedOrderRequest gor : gors) {
            if (this.changeToPaused) {
                gor.setState(GeneralizedOrderRequest.State.PAUSED);
            }
            long oldDate = switch (this.offsetStartPoint) {
                case OffsetStartPoint.RELEASE_DATE -> gor.getReleaseDate();
                case OffsetStartPoint.START_DATE -> gor.getStartDate();
                default -> throw new IllegalStateException();
            };
            if (GeneralizedRequest.isDateValid(oldDate)) {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(oldDate);
                c.add(this.pauseOffsetCalendarField, this.pauseOffsetAmount);
                long newDate = c.getTimeInMillis();
                gor.setReleaseDate(newDate);
                continue;
            }
            problems.add(Problem.createProblem2("03050", gor));
        }
    }

    private void removeGorsFromSuperplan(Set<GeneralizedOrderRequest> gors, List<Problem> problems) {
        for (GeneralizedOrderRequest gor : gors) {
            ProductionTreeAlgorithms.removeRelatedActivities(gor);
            if (gor.isFixed() || gor.isActiongramLocked()) continue;
            try {
                gor.cancelActiongram();
            }
            catch (IllegalArgumentException x) {
                problems.add(Problem.createProblem2("03100", gor));
            }
        }
    }

    private void fixRebuilds(Superplan superplan) {
        RebuildPlannerUtils.fixAndRegister(superplan.getPlan());
    }

    private void replanGors(Superplan superplan, Set<GeneralizedOrderRequest> gors, List<Problem> problems) {
        this.userSelectGors(superplan, gors);
        MokosRunner mokosRunner = new MokosRunner();
        try {
            mokosRunner.setSuperplan(superplan);
            mokosRunner.run();
        }
        catch (PlanNotValidException x) {
            problems.add(Problem.createProblem2("03150", x.getMessage()));
        }
    }

    private void userSelectGors(Superplan superplan, Set<GeneralizedOrderRequest> gors) {
        for (GeneralizedOrderRequest gor : superplan.getGors()) {
            gor.setUserSelected(gors.contains(gor));
        }
    }

    public static enum OffsetStartPoint {
        RELEASE_DATE(Localizer.getString("command.pause_gors.use_rd")),
        START_DATE(Localizer.getString("command.pause_gors.use_sd"));

        private final String title;

        private OffsetStartPoint(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum TimeUnit {
        DAY(Localizer.getString("command.pause_gors.unit_day"), 5),
        MONTH(Localizer.getString("command.pause_gors.unit_month"), 2);

        private final String title;
        private final int calendarField;

        private TimeUnit(String title, int calendarField) {
            this.title = title;
            this.calendarField = calendarField;
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        public static TimeUnit forCalendarField(int field) {
            for (TimeUnit unit : TimeUnit.values()) {
                if (unit.calendarField != field) continue;
                return unit;
            }
            return null;
        }

        public String toString() {
            return this.title;
        }
    }
}

